package io.dyte.core.controllers

typealias DyteStageStatus = StageStatus

enum class StageStatus {
  OFF_STAGE,
  REQUESTED_TO_JOIN_STAGE,
  ACCEPTED_TO_JOIN_STAGE,
  REJECTED_TO_JOIN_STAGE,
  ON_STAGE;

  companion object {
    fun fromMap(stage: String): DyteStageStatus {
      return when (stage) {
        "offStage" -> OFF_STAGE
        "requestedToJoinStage" -> REQUESTED_TO_JOIN_STAGE
        "acceptedToJoinStage" -> ACCEPTED_TO_JOIN_STAGE
        "rejectedToJoinStage" -> REJECTED_TO_JOIN_STAGE
        "onStage" -> ON_STAGE
        else -> OFF_STAGE
      }
    }
  }

  override fun toString(): String {
    val strString =
      when (this) {
        OFF_STAGE -> "offStage"
        REQUESTED_TO_JOIN_STAGE -> "requestedToJoinStage"
        ACCEPTED_TO_JOIN_STAGE -> "acceptedToJoinStage"
        REJECTED_TO_JOIN_STAGE -> "rejectedToJoinStage"
        ON_STAGE -> "onStage"
      }

    return strString
  }
}
