package io.dyte.core.controllers

import io.dyte.core.observability.DyteLogger
import kotlinx.coroutines.launch

internal class ConnectionController(controllerContainer: IControllerContainer) :
  IConnectionController, BaseController(controllerContainer) {

  /**
   * in case of network change error -> disconnect -> reconnect_attempt -> reconnect -> connect
   *
   * in case of network dropped
   */
  override fun onSocketStateChanged(socketState: String) {
    DyteLogger.info("socket state changed $socketState")
    // we are not doing here anything purpose fully, we explicitely manage network state with media
    // soup transports
  }

  override fun onSendTransportStateChanged(state: String) {
    DyteLogger.info("send transport state updated $state")
    handleTransportStateUpdated(state)
  }

  override fun onReceiveTransportStateChanged(state: String) {
    DyteLogger.info("receive transport state updated $state")
    handleTransportStateUpdated(state)
  }

  /**
   * whenever there is network change, transports from media soup goes to disconnected and then
   * later in failed. In either case we trigger meeting room disconnected and leave the call.
   */
  private fun handleTransportStateUpdated(newState: String) {
    // if (newState == "disconnected" || newState == "failed") {
    //   closeConnections()
    //   controllerContainer.eventController.triggerEvent(DyteEventType.OnMeetingRoomDisconnected)
    // }
  }

  private fun closeConnections() {
    serialScope.launch {
      DyteLogger.warn("close connections")
      controllerContainer.roomNodeSocketService.disconnect()
      controllerContainer.sockratesSocketService.disconnect()
      controllerContainer.sfuUtils.leaveCall()
      controllerContainer.eventController.dispose()
    }
  }
}

interface IConnectionController {
  fun onSocketStateChanged(socketState: String)

  fun onSendTransportStateChanged(state: String)

  fun onReceiveTransportStateChanged(state: String)
}
