package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.Serializable

/** response for event [InboundMeetingEventType.WEB_SOCKET_CONNECT_TRANSPORT] */
@Serializable
data class WebSocketChatMessagesModel(val messages: List<WebSocketChatMessage>? = null) :
  BasePayloadModel()

@Serializable
data class WebSocketChatMessage(
  val message: String? = null,
  val userId: String,
  val displayName: String,
  val type: Int,
  val link: String? = null,
  val time: Long? = null,
  val name: String? = null, // fileName in File type chat message
  val size: Long? = null // fileSize in File type chat message
) : BasePayloadModel()
