package io.dyte.core.socket.events

enum class InboundMeetingEventType(val type: String) {
  WEB_SOCKET_ROOM_STATE("websocket/room-state"),
  WEB_SOCKET_ROUTER_CAPABILITY("websocket/router-capability"),
  WEB_SOCKET_CREATE_TRANSPORT("websocket/create-transport"),
  WEB_SOCKET_JOIN_ROOM("websocket/join-room"),
  WEB_SOCKET_PEER_JOINED("websocket/peer-joined"),
  WEB_SOCKET_PEER_LEFT("websocket/peer-closed"),
  WEB_SOCKET_ACTIVE_SPEAKER("websocket/active-speaker"),
  WEB_SOCKET_NO_ACTIVE_SPEAKER("websocket/no-active-speaker"),
  WEB_SOCKET_PEER_PINNED("websocket/pin-peer"),
  WEB_SOCKET_RECORDING_STARTED("websocket/recording-started"),
  WEB_SOCKET_RECORDING_STOPPED("websocket/recording-stopped"),
  WEB_SOCKET_WAITLIST_PEER_ADDED("websocket/waitlist-peer-added"),
  WEB_SOCKET_WAITLIST_PEER_ACCEPTED("websocket/waitlist-accepted"),
  WEB_SOCKET_WAITLIST_PEER_REJECTED("websocket/waitlist-rejected"),
  WEB_SOCKET_WAITLIST_PEER_CLOSED("websocket/waitlist-peer-closed"),
  WEB_SOCKET_SELECTED_PEERS("websocket/selected-peers"),
  WEB_SOCKET_NEW_CONSUMER("websocket/new-consumer"),
  WEB_SOCKET_RESUME_CONSUMER("websocket/consumer-resumed"),
  WEB_SOCKET_CLOSE_CONSUMER("websocket/consumer-closed"),
  WEB_SOCKET_PAUSE_CONSUMER("websocket/consumer-paused"),
  WEB_SOCKET_CONNECT_TRANSPORT("websocket/connect-transport"),
  WEB_SOCKET_PRODUCER_CONNECT("websocket/producer-connect"),
  WEB_SOCKET_PRODUCER_CLOSED("websocket/producer-closed"),
  WEB_SOCKET_PEER_MUTED("websocket/peer-muted"),
  WEB_SOCKET_PEER_UNMUTED("websocket/peer-unmuted"),
  WEB_SOCKET_MUTE_ALL_VIDEO("websocket/mute-all-video"),
  WEB_SOCKET_MUTE_ALL_AUDIO("websocket/mute-all"),
  WEB_SOCKET_DISABLE_VIDEO("websocket/disable-video"),
  WEB_SOCKET_DISABLE_AUDIO("websocket/disable-audio"),
  WEB_SOCKET_ON_CHAT_MESSAGES("websocket/get-chat-messages"),
  WEB_SOCKET_ON_CHAT_MESSAGE("websocket/new-chat-message"),
  WEB_SOCKET_ON_POLL("websocket/update-poll"),
  WEB_SOCKET_ON_POLLS("websocket/get-polls"),
  WEB_SOCKET_GET_PAGE("websocket/get-page"),
  WEB_SOCKET_KICKED("websocket/kicked"),

  /** just for local user */
  WEB_SOCKET_STARTED_PRESENTING("websocket/started-presenting"),
  WEB_SOCKET_STOPPED_PRESENTING("websocket/stopped-presenting"),

  /** for remote peers */
  WEB_SOCKET_PEER_STARTED_PRESENTING("websocket/peer-started-presenting"),
  WEB_SOCKET_PEER_STOPPED_PRESENTING("websocket/peer-stopped-presenting"),
  WEB_SOCKET_PEER_ADDED_TO_STAGE("websocket/peer-added-to-stage"),
  WEB_SOCKET_PEER_REJECTED_TO_JOIN_STAGE("websocket/peer-rejected-to-join-stage"),
  WEB_SOCKET_PEER_REMOVED_FROM_STAGE("websocket/peer-removed-from-stage"),
  WEB_SOCKET_REQUEST_TO_JOIN_STAGE_PEER_WITHDRAWN("websocket/request-to-join-stage-peer-withdrawn"),
  WEB_SOCKET_REQUEST_TO_JOIN_STAGE_PEER_ADDED("websocket/request-to-join-stage-peer-added"),
  WEB_SOCKET_REQUEST_TO_JOIN_STAGE_ACCEPTED("websocket/request-to-join-stage-accepted"),
  WEB_SOCKET_REQUEST_TO_JOIN_STAGE_REJECTED("websocket/request-to-join-stage-rejected"),
  WEB_SOCKET_REMOVED_FROM_STAGE("websocket/removed-from-stage"),
  WEB_SOCKET_PLUGIN_ENABLED("websocket/enable-plugin"),
  WEB_SOCKET_PLUGIN_DISABLED("websocket/disable-plugin"),
  WEB_SOCKET_PLUGIN_EVENT("websocket/plugin-event"),
  WEB_SOCKET_PLUGIN_DATA("websocket/plugin-data"),
  WEB_SOCKET_ROOM_MESSAGE("websocket/room-message")
}
