package io.dyte.core.models

import io.dyte.core.controllers.ParticipantController
import io.dyte.core.feat.ParticipantFlags
import io.dyte.core.host.IHostController
import io.dyte.core.network.info.SelfPermissions

@Deprecated("Use DyteJoinedMeetingParticipant")
open class DyteScreenShareMeetingParticipant
internal constructor(
  override val id: String,
  override val userId: String,
  override var name: String,
  override val picture: String?,
  override val isHost: Boolean,
  override val clientSpecificId: String?,
  override val flags: ParticipantFlags,
  override val presetName: String,
  participantController: ParticipantController,
  internal val _hostController: IHostController,
  internal val _selfPermissions: SelfPermissions
) :
  DyteJoinedMeetingParticipant(
    id,
    userId,
    name,
    picture,
    isHost,
    clientSpecificId,
    flags,
    presetName,
    participantController,
    _hostController,
    _selfPermissions
  ) {
  companion object {
    fun fromJoinedParticipant(
      participant: DyteJoinedMeetingParticipant
    ): DyteScreenShareMeetingParticipant {
      return DyteScreenShareMeetingParticipant(
          id = participant.id,
          userId = participant.userId,
          name = participant.name,
          picture = participant.picture,
          isHost = participant.isHost,
          clientSpecificId = participant.clientSpecificId,
          flags = participant.flags,
          presetName = participant.presetName,
          participantController = participant.participantController,
          _hostController = participant.hostController,
          _selfPermissions = participant.selfPermissions,
        )
        .apply { _screenShareTrack = participant._screenShareTrack }
    }
  }
}
