package io.dyte.core.feat

import io.dyte.core.controllers.ParticipantController
import io.dyte.core.controllers.WaitlistController
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

class DyteWaitlistedParticipant
internal constructor(
  override val id: String,
  override val userId: String,
  override var name: String,
  override val picture: String?,
  override val isHost: Boolean,
  override val clientSpecificId: String?,
  override val flags: ParticipantFlags,
  override val presetName: String,
  participantController: ParticipantController,
  private val waitlistController: WaitlistController,
  private val scope: CoroutineScope
) :
  DyteMeetingParticipant(
    id,
    userId,
    name,
    picture,
    isHost,
    clientSpecificId,
    flags,
    presetName,
    participantController
  ) {

  /** Accept the request and let the participant in the meeting */
  @Throws(Exception::class)
  open fun acceptWaitListedRequest() {
    scope.launch { waitlistController.acceptWaitlistedRequest(this@DyteWaitlistedParticipant) }
  }

  /** Reject the request, do not permit the participant to join the meeting */
  @Throws(Exception::class)
  open fun rejectWaitListedRequest() {
    scope.launch { waitlistController.rejectWaitlistedRequest(this@DyteWaitlistedParticipant) }
  }
}
