package io.dyte.core.controllers.stage

import io.dyte.core.controllers.DyteStageStatus
import io.dyte.core.models.DyteJoinedMeetingParticipant
import io.dyte.core.models.DyteSelfParticipant
import io.dyte.core.network.info.SelfPermissions
import io.dyte.core.socket.socketservice.ISockratesSocketService
import io.dyte.core.socket.socketservice.SocketServiceEventListener
import io.dyte.core.socket.socketservice.SocketServiceUtils
import socket.livestreaming.DenyStageAccessRequest
import socket.livestreaming.GetStageRequestsResponse
import socket.livestreaming.GrantStageAccessRequest
import socket.livestreaming.LeaveStageRequest

internal class StageSocketServiceController(
  val self: DyteSelfParticipant,
  private val userId: String,
  private val permissions: SelfPermissions,
  private val socketService: ISockratesSocketService,
) : BaseStageController(self) {

  override val viewers: List<DyteJoinedMeetingParticipant>
    get() = TODO("Not yet implemented")

  private val socketEventListener =
    object : SocketServiceEventListener {
      override fun onEvent(event: Int, eventId: String?, payload: ByteArray?) {
        when (event) {
          // when new peer joins stage
          SocketServiceUtils.RoomEvent.GET_STAGE_PEERS.id -> {
            /*payload?.let {
              val response = GetStagePeersResponse.ADAPTER.decode(payload)
              _stageParticipants.clear()
              response.stage_peers.forEach { peerId ->
                val peersToRemove = _requestsToPresent.filter { it.id == peerId }
                _requestsToPresent.removeAll(peersToRemove.toSet())
                peersToRemove.forEach { peerOnStage ->
                  _stageParticipants.add(DyteStageParticipant(peerOnStage.name, peerOnStage.id))
                }
              }
            }*/
          }
          /*SocketServiceUtils.RoomEvent.GRANT_STAGE_REQUEST.id -> {
            setStageStatus(StageStatus.ACCEPTED_TO_JOIN_STAGE)
          }*/

          // when someone requests to be on stage
          SocketServiceUtils.RoomEvent.GET_STAGE_REQUESTS.id -> {
            payload?.let {
              val response = GetStageRequestsResponse.ADAPTER.decode(payload)
              _accessRequests.clear()
              response.stage_requests.forEach { requestPeer ->
                // TODO : fix this.
                /*val participant =
                DyteJoinedMeetingParticipant(
                    requestPeer.user_id,
                    requestPeer.user_id,
                    requestPeer.display_name,
                    null,
                    false,
                    null,
                    ParticipantFlags(false, false, false),
                    "", )*/
                /*val requestedPeer =
                  DyteStageParticipant(requestPeer.display_name, requestPeer.user_id)
                _requestsToPresent.add(requestedPeer)*/
              }
            }
            emitEvent { it.onStageRequestsUpdated(_accessRequests) }
          }
          SocketServiceUtils.RoomEvent.REQUEST_STAGE_ACCESS.id -> {}
          SocketServiceUtils.RoomEvent.JOIN_STAGE.id -> {}
          else -> {}
        }
      }
    }

  override fun setupEvents() {
    socketService.subscribe(
      SocketServiceUtils.RoomEvent.REQUEST_STAGE_ACCESS.id,
      socketEventListener
    )
    socketService.subscribe(
      SocketServiceUtils.RoomEvent.REQUEST_STAGE_ACCESS.id,
      socketEventListener
    )
    socketService.subscribe(SocketServiceUtils.RoomEvent.GET_STAGE_REQUESTS.id, socketEventListener)
  }

  override suspend fun requestAccess() {
    socketService.send(SocketServiceUtils.RoomEvent.REQUEST_STAGE_ACCESS.id, null)
    self._stageStatus = DyteStageStatus.REQUESTED_TO_JOIN_STAGE
  }

  override suspend fun denyAccess(id: String) {
    socketService.send(
      SocketServiceUtils.RoomEvent.DENY_STAGE_REQUEST.id,
      DenyStageAccessRequest(listOf(id)).encode()
    )
  }

  override suspend fun denyAccessAll() {
    val ids = _accessRequests.map { it.id }
    socketService.send(
      SocketServiceUtils.RoomEvent.DENY_STAGE_REQUEST.id,
      DenyStageAccessRequest(ids).encode()
    )
  }

  override suspend fun grantAccess(id: String) {
    socketService.send(
      SocketServiceUtils.RoomEvent.GRANT_STAGE_REQUEST.id,
      GrantStageAccessRequest(listOf(id)).encode()
    )
  }

  override suspend fun grantAccessAll() {
    val ids = _accessRequests.map { it.id }
    socketService.send(
      SocketServiceUtils.RoomEvent.GRANT_STAGE_REQUEST.id,
      GrantStageAccessRequest(ids).encode()
    )
  }

  override suspend fun join() {
    // TODO : implement this
    /*if (controllerContainer.selfController.roomJoined.not()) {
      controllerContainer.socketController.connect()
    }
    controllerContainer.roomNodeController.joinRoom()*/
    socketService.send(SocketServiceUtils.RoomEvent.JOIN_STAGE.id, null)
    self._stageStatus = DyteStageStatus.ON_STAGE
  }

  override suspend fun leave() {
    val request = LeaveStageRequest(listOf(userId)).encode()
    socketService.send(SocketServiceUtils.RoomEvent.LEAVE_STAGE.id, request)
    // TODO : disconnect from media here
  }

  override suspend fun kick(id: String) {
    val leaveStageRequest = LeaveStageRequest(listOf(id)).encode()
    socketService.send(SocketServiceUtils.RoomEvent.LEAVE_STAGE.id, leaveStageRequest)
  }

  override suspend fun cancelRequestAccess() {
    socketService.send(SocketServiceUtils.RoomEvent.CANCEL_STAGE_REQUEST.id, null)
  }
}
