package io.dyte.core.listeners

/**
 * Dyte meeting room events listener
 *
 * You can subscribe to all room events by implementing this interface. To subscribe pass
 * implementation to [io.dyte.core.DyteMobileClient.addMeetingRoomEventsListener]
 */
interface DyteMeetingRoomEventsListener : DyteConnectionEventListener {
  fun onMeetingInitStarted() {}

  fun onMeetingInitCompleted() {}

  fun onMeetingInitFailed(exception: Exception) {}

  /**
   * On meeting room join started Triggered once the sdk starts making connection to the roomname
   * you passed. Ideally one should show loader on UI once this event is triggered.
   */
  fun onMeetingRoomJoinStarted() {}

  fun onMeetingRoomJoinCompleted() {}

  /**
   * On meeting room join failed Triggered when some error happened while executing
   * [io.dyte.core.DyteMobileClient.joinRoom] or [io.dyte.core.DyteMobileClient.init]
   *
   * @param exception - actual exception. This can be either http exception or any android exception
   */
  fun onMeetingRoomJoinFailed(exception: Exception) {}

  fun onMeetingRoomLeaveStarted() {}

  /** On meeting room left Triggered once this user is left successfully from the meeting */
  fun onMeetingRoomLeaveCompleted() {}
}

interface DyteConnectionEventListener : ExternalEventListener {

  /** When connection to meeting room is lost due to network conditions */
  fun onMeetingRoomDisconnected() {}

  /** Triggered when Local user starts connecting to the meeting room during initialization. */
  fun onConnectingToMeetingRoom() {}

  /** Triggered when Local user connects to the meeting room after initialization. */
  fun onConnectedToMeetingRoom() {}

  /** Triggered when Local user disconnects while leaving the the meeting room. */
  fun onDisconnectedFromMeetingRoom() {}

  /** Triggered when Local user fails to connect to the meeting room during initialization. */
  fun onMeetingRoomConnectionFailed() {}

  /**
   * Triggered when Dyte client detects a connection drop and starts trying reconnection with the
   * meeting room.
   */
  fun onReconnectingToMeetingRoom() {}

  /** Triggered when Dyte client successfully reconnects to the meeting room. */
  fun onReconnectedToMeetingRoom() {}

  /** Triggered when Dyte client fails to reconnect to the meeting room. */
  fun onMeetingRoomReconnectionFailed() {}
}
