package io.dyte.core.controllers

import io.dyte.core.network.ApiClient
import io.dyte.core.observability.DyteLogger
import io.dyte.core.socket.socketservice.SocketServiceEventListener
import io.dyte.core.socket.socketservice.SocketServiceUtils
import io.dyte.core.socket.socketservice.SockratesSocketService
import kotlinx.coroutines.CoroutineScope
import media.edge.RecordingStartedBroadcastResponse
import media.edge.RecordingStoppedBroadcastResponse

internal class RecordingSocketServiceController(
  apiClient: ApiClient,
  canRecord: Boolean,
  private val socket: SockratesSocketService,
  scope: CoroutineScope
) : RecordingController(apiClient, canRecord, scope) {

  override fun setupEvents() {
    socket.subscribe(
      SocketServiceUtils.MediaEvent.RECORDING_STARTED_BROADCAST.id,
      onRecordingStartedBroadcast
    )
    socket.subscribe(
      SocketServiceUtils.MediaEvent.RECORDING_STOPPED_BROADCAST.id,
      onRecordingStoppedBroadcast
    )
  }

  val onRecordingStartedBroadcast =
    object : SocketServiceEventListener {
      override fun onEvent(event: Int, eventId: String?, payload: ByteArray?) {
        try {
          var peerId: String? = null

          if (payload != null) {
            val data = RecordingStartedBroadcastResponse.ADAPTER.decode(payload)
            peerId = data.participant_id
          }

          onRecordingPeerJoined()
        } catch (e: Error) {
          DyteLogger.error("HiveController: Error in recording started broadcast $e")
        }
      }
    }

  val onRecordingStoppedBroadcast =
    object : SocketServiceEventListener {
      override fun onEvent(event: Int, eventId: String?, payload: ByteArray?) {
        try {
          var peerId: String? = null

          if (payload != null) {
            val data = RecordingStoppedBroadcastResponse.ADAPTER.decode(payload)
            peerId = data.participant_id
          }
          onRecordingPeerLeft()
        } catch (e: Error) {
          DyteLogger.error("HiveController: Error in recording stopped broadcast $e")
        }
      }
    }
}
