package io.dyte.core.host

import io.dyte.core.controllers.ISocketController
import io.dyte.core.observability.DyteLogger
import io.dyte.core.socket.events.OutboundMeetingEventType
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.JsonPrimitive

internal class HostSocketControllerHandler(
  private val socketController: ISocketController,
) : HostSocketHandler {
  override suspend fun kickPeer(peerId: String): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(peerId)
      socketController.sendMessage(OutboundMeetingEventType.KICK_PEER, JsonObject(content))
      true
    } catch (e: Exception) {
      DyteLogger.error("HostSocketHandler::kick_peer::failed", e)
      false
    }
  }

  override suspend fun kickAll(): Boolean {
    return try {
      socketController.sendMessage(OutboundMeetingEventType.KICK_ALL, null)
      true
    } catch (e: Exception) {
      DyteLogger.error("HostSocketHandler::kick_all::failed", e)
      false
    }
  }

  override suspend fun muteAllAudio(allowUnmute: Boolean?): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["allowUnMute"] = JsonPrimitive(allowUnmute)
      socketController.sendMessage(OutboundMeetingEventType.MUTE_ALL_AUDIO, JsonObject(content))
      true
    } catch (e: Exception) {
      DyteLogger.error("HostSocketHandler::mute_all_audio::failed", e)
      false
    }
  }

  override suspend fun muteAllVideo(): Boolean {
    return try {
      socketController.sendMessage(OutboundMeetingEventType.MUTE_ALL_VIDEO, null)
      true
    } catch (e: Exception) {
      DyteLogger.error("HostSocketHandler::mute_all_video::failed", e)
      false
    }
  }

  override suspend fun muteAudio(peerId: String): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(peerId)
      socketController.sendMessage(OutboundMeetingEventType.MUTE_PEER_AUDIO, JsonObject(content))
      true
    } catch (e: Exception) {
      DyteLogger.error("HostSocketHandler::mute_audio::failed", e)
      false
    }
  }

  override suspend fun muteVideo(peerId: String): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(peerId)
      socketController.sendMessage(OutboundMeetingEventType.MUTE_PEER_VIDEO, JsonObject(content))
      true
    } catch (e: Exception) {
      DyteLogger.error("HostSocketHandler::mute_video::failed", e)
      false
    }
  }

  override suspend fun pinPeer(peerId: String): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(peerId)
      socketController.sendMessage(OutboundMeetingEventType.PIN_PARTICIPANT, JsonObject(content))
      true
    } catch (e: Exception) {
      DyteLogger.error("HostSocketHandler::pin_peer::failed", e)
      false
    }
  }

  override suspend fun unpinPeer(): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      val nullString: String? = null
      content["id"] = JsonPrimitive(nullString)
      socketController.sendMessage(OutboundMeetingEventType.PIN_PARTICIPANT, JsonObject(content))
      true
    } catch (e: Exception) {
      DyteLogger.error("HostSocketHandler::unpin_peer::failed", e)
      false
    }
  }
}
