package io.dyte.core

import android.content.Context
import android.util.AttributeSet
import android.widget.LinearLayout
import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.models.DyteScreenShareMeetingParticipant
import io.dyte.core.observability.DyteLogger
import io.dyte.webrtc.VideoStreamTrack
import io.dyte.webrtc.WebRtc
import io.webrtc.EglBase
import io.webrtc.RendererCommon.ScalingType.SCALE_ASPECT_FIT
import io.webrtc.SurfaceViewRenderer
import io.webrtc.VideoSink

class VideoView : LinearLayout {
  private var participant: DyteMeetingParticipant? = null
  private var videoRenderer: SurfaceViewRenderer? = null
  private var controllerContainer: IControllerContainer? = null

  constructor(context: Context) : super(context) {
    init(context)
  }

  constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
    init(context)
  }

  constructor(
    context: Context,
    attrs: AttributeSet?,
    defStyleAttr: Int
  ) : super(context, attrs, defStyleAttr) {
    init(context)
  }

  private fun init(context: Context) {
    inflate(context, R.layout.view_video, this)
    videoRenderer = findViewById(R.id.video_renderer)
  }

  internal fun setup(
    controllerContainer: IControllerContainer,
    dyteParticipant: DyteMeetingParticipant
  ) {
    this.participant = dyteParticipant
    this.controllerContainer = controllerContainer
    activate()
  }

  private fun activate() {
    videoRenderer?.setScalingType(SCALE_ASPECT_FIT)
    try {
      videoRenderer?.init(WebRtc.rootEglBase.eglBaseContext as EglBase.Context, null)
    } catch (e: Exception) {
      DyteLogger.error("VideoView::activate::error", e)
    }
  }

  fun renderVideo() {
    try {
      var track: VideoStreamTrack? = null
      if (
        participant is DyteScreenShareMeetingParticipant &&
          (participant as DyteScreenShareMeetingParticipant).screenShareTrack != null
      ) {
        track = (participant as DyteScreenShareMeetingParticipant).screenShareTrack!!
      } else if (participant?.videoEnabled == true && participant?.videoTrack != null) {
        track = participant?.videoTrack
      }

      if (track != null) {
        videoRenderer?.visibility = VISIBLE
        track.addSinkCatching(videoRenderer!!)
      } else {
        videoRenderer?.visibility = GONE
      }
    } catch (e: Exception) {
      DyteLogger.error("VideoView::renderVideo::error", e)
    }
  }

  fun stopVideoRender() {
    try {
      var track: VideoStreamTrack? = null
      if (participant?.videoEnabled == true && participant?.videoTrack != null) {
        track = participant?.videoTrack
      }

      if (track != null) {
        videoRenderer?.visibility = VISIBLE
        track.removeSink(videoRenderer!!)
      } else {
        videoRenderer?.visibility = GONE
      }
    } catch (e: Exception) {
      e.printStackTrace()
    }
  }

  fun release() {
    if (participant?.videoEnabled == true && participant?.videoTrack is VideoStreamTrack) {
      val track = participant?.videoTrack
      track?.removeSink(videoRenderer!!)
    }
  }

  private fun VideoStreamTrack.addSinkCatching(sink: VideoSink) {
    // runCatching as track may be disposed while activity was in pause mode
    runCatching { addSink(sink) }
  }
}
