package io.dyte.core.socket

internal class SocketIoConnectionEventAdapter {
  private var previousSocketIoEvent: SocketEvent<*> = SocketEvent.Disconnect
  private var reconnectAttemptNumber = 0

  fun onSocketIoEvent(socketEvent: SocketEvent<*>): SocketConnectionEvent? {
    if (previousSocketIoEvent == socketEvent) {
      previousSocketIoEvent = socketEvent // We still save the current event as previous
      return null
    }

    val socketConnectionEvent =
      when (socketEvent) {
        SocketEvent.Connect -> {
          if (
            previousSocketIoEvent == SocketEvent.ReconnectAttempt ||
              previousSocketIoEvent == SocketEvent.Reconnect
          ) {
            SocketConnectionEvent.Reconnected
          } else {
            SocketConnectionEvent.Connected
          }
        }
        SocketEvent.Connecting -> {
          if (previousSocketIoEvent == SocketEvent.Error) {
            null
          } else {
            SocketConnectionEvent.Connecting
          }
        }
        SocketEvent.Disconnect -> {
          if (previousSocketIoEvent == SocketEvent.Error) {
            null
          } else {
            SocketConnectionEvent.Disconnected(code = 1000, reason = "Normal Closure")
          }
        }
        SocketEvent.Error -> {
          if (previousSocketIoEvent == SocketEvent.Connect) {
            reconnectAttemptNumber = 0
            SocketConnectionEvent.Reconnecting
          } else if (previousSocketIoEvent == SocketEvent.ReconnectAttempt) {
            SocketConnectionEvent.ReconnectionAttemptFailed(reconnectAttemptNumber)
          } else {
            SocketConnectionEvent.ConnectionFailed
          }
        }
        SocketEvent.Reconnect -> {
          null
        }
        SocketEvent.ReconnectAttempt -> {
          reconnectAttemptNumber++
          SocketConnectionEvent.ReconnectionAttempt(reconnectAttemptNumber)
        }
        else -> {
          null
        }
      }

    previousSocketIoEvent = socketEvent
    return socketConnectionEvent
  }
}
