package io.dyte.core.feat

import io.dyte.core.controllers.DyteRecordingState
import io.dyte.core.controllers.IControllerContainer

/**
 * Dyte recording
 *
 * @constructor Create empty Dyte recording
 * @property controllerContainer
 */
class DyteRecording internal constructor(private val controller: IControllerContainer) {
  val recordingState: DyteRecordingState
    get() = controller.recordingController.getState()

  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["recordingState"] = recordingState
    return map
  }

  /** Starts recording of a given meeting */
  fun start() {
    controller.recordingController.start()
  }

  /** Stops recording of a given meeting */
  fun stop() {
    controller.recordingController.stop()
  }
}
