package io.dyte.core.network.models

import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class FeaturesData(
  @JsonNames("logrocket") val logrocket: FeaturesOrganizationModelWrapper?,
  @JsonNames("lr2") val newCallstatsOrganization: List<FeaturesOrganizationModelWrapper>?
)

@OptIn(ExperimentalSerializationApi::class)
@Serializable
data class FeaturesOrganizationModelWrapper(
  @JsonNames("if") val wrapper: FeaturesOrganizationModel?,
  @JsonNames("config") val config: String? = null
)

@Serializable
@OptIn(ExperimentalSerializationApi::class)
data class FeaturesOrganizationModel(val organization: List<String>?)
