package io.dyte.core.network

import io.ktor.client.HttpClient
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation
import io.ktor.client.plugins.logging.LogLevel
import io.ktor.client.plugins.logging.Logger
import io.ktor.client.plugins.logging.Logging
import io.ktor.client.plugins.logging.SIMPLE
import io.ktor.serialization.kotlinx.json.json
import kotlinx.serialization.json.Json

internal open class BaseApiService {
  val client: HttpClient = HttpClient {
    install(Logging) {
      logger = Logger.SIMPLE
      level = LogLevel.ALL
    }
    install(ContentNegotiation) {
      json(
        Json {
          prettyPrint = true
          isLenient = true
          ignoreUnknownKeys = true
        }
      )
    }
  }

  companion object {
    val json = Json { ignoreUnknownKeys = true }
  }
}
