package io.dyte.core.listeners

import io.dyte.core.controllers.DyteRecordingState

interface DyteRecordingEventsListener {
  /**
   * On meeting recording started
   *
   * Triggered when someone starts recording this room
   */
  fun onMeetingRecordingStarted() {}

  /**
   * On meeting recording ended
   *
   * Triggered when someone stops recording this room
   */
  fun onMeetingRecordingEnded() {}

  fun onMeetingRecordingStopError(e: Exception) {}

  fun onMeetingRecordingStateUpdated(state: DyteRecordingState) {}
}
