package io.dyte.core.listeners

import io.dyte.core.feat.DytePollMessage

interface DytePollEventsListener {
  /**
   * On poll updates
   *
   * Triggered when there is a new poll available in this room or if there is any update on existing
   * poll. Update on poll can happen once user votes on any given poll.
   *
   * @param pollMessages list of all polls in this room. This also contains polls exchanged before
   *   this peer joined in this room
   */
  fun onPollUpdates(pollMessages: List<DytePollMessage>) {}

  fun onNewPoll(poll: DytePollMessage) {}
}
