package io.dyte.core.feat

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.models.DyteMeetingType

class DyteMeta internal constructor(private val controller: IControllerContainer) {
  val roomName: String
    get() = controller.metaController.getRoomName()

  val meetingTitle: String
    get() = controller.metaController.getMeetingTitle()

  val meetingStartedTimestamp: String
    get() = controller.metaController.getMeetingStatedTimestamp()

  val meetingStartedTimeInEpox: Long
    get() = controller.metaController.getMeetingStatedTime()

  val meetingType: DyteMeetingType
    get() = controller.metaController.getMeetingType()

  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["roomName"] = roomName
    map["meetingTitle"] = meetingTitle
    map["meetingStartedTimestamp"] = meetingStartedTimestamp
    map["meetingType"] = meetingType.name
    return map
  }
}
