package io.dyte.core.events

import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.SharedFlow

internal interface JoinRoomEventPublisher {
  suspend fun publish()
}

internal interface JoinRoomEventReceiver {
  val joinRoomEvent: SharedFlow<Unit>
}

internal class JoinRoomEventManager : JoinRoomEventPublisher, JoinRoomEventReceiver {
  private val _joinRoomEvent: MutableSharedFlow<Unit> = MutableSharedFlow()
  override val joinRoomEvent: SharedFlow<Unit> = _joinRoomEvent

  override suspend fun publish() {
    _joinRoomEvent.emit(Unit)
  }
}
