package io.dyte.core.listeners

import io.dyte.core.controllers.StageStatus
import io.dyte.core.models.DyteSelfParticipant
import io.dyte.core.models.WaitListStatus

/**
 * Dyte self events listener
 *
 * You can subscribe to all self events by implementing this interface. To subscribe pass
 * implementation to [io.dyte.core.DyteMobileClient.addSelfEventsListener]
 *
 * @constructor Create empty Dyte self events listener
 */
// TODO : device change callback.
interface DyteSelfEventsListener {

  fun onMeetingRoomJoinedWithoutCameraPermission() {}

  fun onMeetingRoomJoinedWithoutMicPermission() {}

  /**
   * Audio update
   *
   * when this participant mutes/un-mutes their audio Also triggered when host toggles audio for
   * this participant
   *
   * @param audioEnabled : true if audio is enabled, false otherwise
   */
  fun onAudioUpdate(audioEnabled: Boolean) {}

  /**
   * Video update
   *
   * when this participant mutes/un-mutes their video. Also triggered when host toggles video for
   * this participant
   *
   * @param videoEnabled : true if video is enabled, false otherwisee
   */
  fun onVideoUpdate(videoEnabled: Boolean) {}

  fun onAudioDevicesUpdated() {}

  fun onProximityChanged(isNear: Boolean) {}

  fun onWaitListStatusUpdate(waitListStatus: WaitListStatus) {}

  fun onStageStatusUpdated(stageStatus: StageStatus) {}

  // called whenever audio/video is updated
  fun onUpdate(participant: DyteSelfParticipant) {}

  /** triggered when host kick this participant or kick all. */
  fun onRemovedFromMeeting() {}

  fun onRoomMessage(message: String) {}
}
