package io.dyte.core.controllers

import io.dyte.core.feat.DytePoll
import io.dyte.core.feat.DytePollMessage
import io.dyte.core.feat.DytePollOption
import io.dyte.core.polls.PollsSocketHandler
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPoll

// TODO : do we really need this ?
internal class PollController(
  controllerContainer: IControllerContainer,
  private val pollsSocketHandler: PollsSocketHandler
) : BaseController(controllerContainer), IPollController {

  internal lateinit var poll: DytePoll

  override val polls: List<DytePollMessage>
    get() = pollsSocketHandler.polls

  override fun init() {
    poll = DytePoll(controllerContainer)
  }

  override suspend fun loadPolls() {
    pollsSocketHandler.loadPolls()
  }

  override fun onNewPoll(websocketPoll: WebSocketPoll) {
    handleSocketPoll(websocketPoll, true)
  }

  override suspend fun vote(dytePollMessage: DytePollMessage, dytePollOption: DytePollOption) {
    if (controllerContainer.presetController.canVoteOnPoll().not()) {
      return
    }

    pollsSocketHandler.vote(dytePollMessage, dytePollOption)
  }

  override suspend fun create(
    question: String,
    options: List<String>,
    anonymous: Boolean,
    hideVotes: Boolean
  ) {
    if (controllerContainer.presetController.canCreatePoll().not()) {
      return
    }

    if (question.isEmpty()) {
      return
    }

    if (options.isEmpty() || options.filter { it.isNotEmpty() }.size < 2) {
      return
    }

    if (controllerContainer.presetController.canCreatePoll().not()) {
      return
    }

    pollsSocketHandler.createPoll(question, options, anonymous, hideVotes)
  }

  private fun handleSocketPoll(webSocketPoll: WebSocketPoll, updateUi: Boolean) {
    pollsSocketHandler.handlePoll(webSocketPoll, updateUi)
  }
}

interface IPollController {
  val polls: List<DytePollMessage>

  suspend fun loadPolls()

  fun onNewPoll(websocketPoll: WebSocketPoll)

  suspend fun vote(dytePollMessage: DytePollMessage, dytePollOption: DytePollOption)

  suspend fun create(
    question: String,
    options: List<String>,
    anonymous: Boolean,
    hideVotes: Boolean
  )
}
