package io.dyte.core.socket.events.payloadmodel.inbound

import io.dyte.core.socket.events.InboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import io.dyte.core.socket.events.payloadmodel.outbound.Codec
import io.dyte.core.socket.events.payloadmodel.outbound.HeaderExtension
import kotlinx.serialization.Serializable

/**
 * response for event [InboundMeetingEventType.WEB_SOCKET_NEW_CONSUMER]
 */
@Serializable
data class WebSocketConsumerModel(
  var peerId: String? = null,
  var producerId: String? = null,
  var id: String? = null,
  var kind: String? = null,
  var rtpParameters: ConsumerRtpParameters? = null,
  var type: String? = null,
  var appData: ConsumerAppData? = null,
  val remotelyPaused: Boolean? = null,
  val producerPaused: Boolean? = null
) : BasePayloadModel()

@Serializable
data class ConsumerRtpParameters(
  val codecs: List<Codec>? = null,
  val headerExtensions: List<HeaderExtension>? = null,
  val encodings: List<Encodings>? = null,
  val rtcp: Rtcp? = null,
  val mid: String? = null
)

@Serializable
data class ConsumerAppData(
  val screenShare: Boolean? = false,
  val peerId: String
)

@Serializable
data class Encodings(
  val ssrc: Int? = null,
  val rtx: Rtx? = null,
  val scalabilityMode: String? = null
)

@Serializable
class Rtx(
  val ssrc: Int? = null
)

@Serializable
data class Rtcp(
  val cname: String? = null,
  val reducedSize: Boolean? = null,
  val mux: Boolean? = null
) 