package io.dyte.core.network.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@Serializable
data class MeetingSessionDataWrapper(
  val success: Boolean,
  val data: MeetingSessionData
)

@Serializable
data class MeetingSessionData(
  @SerialName("title") val title: String? = null,
  @JsonNames("room_node_link", "roomNodeLink") val roomNodeLink: String? = null,
  @SerialName("use_hive_media") val useHive: Boolean? = false,
)

/**
 * {
"data": {
"session": {
"title": "Monday Sprint Planning",
"roomNodeLink": "https://room-node-ap-south-1-0.cluster.dyte.in",
"roomName": "tpzroe-lztvyk",
"password": null
}
}
}
 */
@Serializable
data class MeetingSessionDataResponseV1(
  val data: MeetingSessionDataWrapperV1
)

@Serializable
data class MeetingSessionDataWrapperV1(
  val session: MeetingSessionData
)
