package io.dyte.core.models

data class DyteMeetingInfo(
  val authToken: String,
  val roomName: String? = null,
  val enableAudio: Boolean = true,
  val enableVideo: Boolean = true,
  val baseUrl: String = "https://api.cluster.dyte.in/v1"
) {
  companion object default {
    @Suppress("UNCHECKED_CAST")
    fun fromMap(map: Map<String, Any?>): DyteMeetingInfo {
      return DyteMeetingInfo(
        roomName = map["roomName"] as String,
        authToken = map["authToken"] as String,
        enableAudio = map["enableAudio"] as Boolean,
        enableVideo = map["enableVideo"] as Boolean,
        baseUrl = map["baseUrl"] as String
      )
    }
  }
}

data class DyteMeetingInfoV2(
  val authToken: String,
  val enableAudio: Boolean = true,
  val enableVideo: Boolean = true,
  val baseUrl: String = "https://api.cluster.dyte.in/v2"
) {
  companion object default {
    @Suppress("UNCHECKED_CAST")
    fun fromMap(map: Map<String, Any?>): DyteMeetingInfoV2 {
      return DyteMeetingInfoV2(
        authToken = map["authToken"] as String,
        enableAudio = map["enableAudio"] as Boolean,
        enableVideo = map["enableVideo"] as Boolean,
        baseUrl = map["baseUrl"] as String,
      )
    }
  }
}