package io.dyte.core.listeners

import io.dyte.core.controllers.LiveStreamStagePeer
import io.dyte.core.controllers.LiveStreamStageRequestPeer
import io.dyte.core.controllers.DyteLivestreamData

interface DyteLiveStreamEventsListener {
  fun onLiveStreamStarting(){}
  fun onLiveStreamStarted() {}
  fun onLiveStreamEnding(){}
  fun onLiveStreamEnded() {}
  fun onLiveStreamErrored() {}

  fun onViewerCountUpdated(count: Int) {}
  fun onStageCountUpdated(count: Int) {}

  fun onStageRequestsUpdated(requests: List<LiveStreamStageRequestPeer>) {}

  fun onJoinRequestAccepted(peer: LiveStreamStagePeer) {}

  fun onJoinRequestRejected(peer: LiveStreamStagePeer) {}
  fun onLiveStreamStateUpdate(data: DyteLivestreamData) {}
}