package io.dyte.core.feat

import io.dyte.core.controllers.Controller
import io.dyte.core.controllers.LiveStreamStagePeer
import io.dyte.core.controllers.LiveStreamStageRequestPeer
import io.dyte.core.controllers.LiveStreamState
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import kotlinx.coroutines.newSingleThreadContext

class DyteLiveStream internal constructor(private val controller: Controller) {
  private val serialScope = CoroutineScope(newSingleThreadContext("DyteLiveStream"))

  val liveStreamUrl: String?
    get() = controller.liveStreamController.livestreamData.liveStreamUrl
  val state: LiveStreamState
    get() = controller.liveStreamController.livestreamData.state
  val roomName: String
    get() = controller.metaController.getMeetingTitle()
  val stageRequestPeers : List<LiveStreamStageRequestPeer>
    get() = controller.liveStreamController.stageRequestPeers

  fun loadStageData() {
    serialScope.launch {
      controller.liveStreamController.loadData()
    }
  }

  fun getStagePeers(onPeersLoaded : (stagePeers : List<LiveStreamStagePeer>) -> Unit) {
    serialScope.launch {
      val peers = controller.liveStreamController.getStagePeers()
      onPeersLoaded.invoke(peers)
    }
  }

  fun getStageRequestPeers(onPeersLoaded : (stageRequests : List<LiveStreamStageRequestPeer>) -> Unit) {
    serialScope.launch {
      val requestPeers = controller.liveStreamController.getStageRequests()
      onPeersLoaded.invoke(requestPeers)
    }
  }

  fun start() {
    serialScope.launch {
      controller.liveStreamController.start()
    }
  }

  fun stop() {
    serialScope.launch {
      controller.liveStreamController.stop()
    }
  }

  /*fun joinStage() {
    serialScope.launch {
      controller.liveStreamController.joinStage()
    }
  }

  fun leaveStage() {
    serialScope.launch {
      controller.liveStreamController.leaveStage()
    }
  }*/

  fun acceptAllRequests() {
    println("DyteMobileClient | DyteLiveStream acceptAllRequests ")
    serialScope.launch {
      val requests = controller.liveStreamController.getStageRequests()
      println("DyteMobileClient | DyteLiveStream acceptAllRequests we've ${requests.size}")
      requests.forEach {
        controller.liveStreamController.acceptRequest(it.userId)
      }
    }
  }

  fun acceptRequest(peer: LiveStreamStageRequestPeer) {
    println("DyteMobileClient | DyteLiveStream acceptRequest ")
    serialScope.launch {
      controller.liveStreamController.acceptRequest(peer.userId)
    }
  }

  fun rejectRequest(peer: LiveStreamStageRequestPeer) {
    println("DyteMobileClient | DyteLiveStream rejectRequest ")
    serialScope.launch {
      controller.liveStreamController.rejectRequest(peer.userId)
    }
  }

  fun rejectAllRequests() {
    println("DyteMobileClient | DyteLiveStream rejectAllRequests ")
    serialScope.launch {
      val requests = controller.liveStreamController.getStageRequests()
      println("DyteMobileClient | DyteLiveStream rejectAllRequests we've ${requests.size}")
      requests.forEach {
        controller.liveStreamController.rejectRequest(it.userId)
      }
    }
  }
}