package io.dyte.core.socket

import kotlinx.serialization.json.JsonArray
import kotlinx.serialization.json.JsonObject

@Suppress("NO_ACTUAL_FOR_EXPECT")
expect class Socket(
  endpoint: String,
  config: SocketOptions? = null,
  build: SocketBuilder.() -> Unit
) {
  fun emit(event: String, data: JsonObject)

  fun emit(event: String, data: JsonArray)

  fun emit(event: String, data: String)

  suspend fun emitAck(event: String, data: String): String?

  fun emitAckAsync(event: String, data: String)

  fun connect()

  fun disconnect()

  fun isConnected(): Boolean
}

interface SocketAckCallback {
  fun call(response: String?)
}
