package io.dyte.core.network

import io.dyte.core.network.models.PresignedUrlRequest
import io.dyte.core.network.models.PresignedUrlResponse
import io.ktor.client.call.body
import io.ktor.client.request.post
import io.ktor.client.request.setBody
import io.ktor.http.ContentType
import io.ktor.http.contentType
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

internal class PresignedUrlApiService(private val baseUrl: String) : BaseApiService() {

  @Deprecated(
    message = "PresignedUrl endpoint requires room-uuid instead of meetingRoomName.",
    replaceWith = ReplaceWith("getPresignedUrl2(filename: String, roomUuid: String)"),
    level = DeprecationLevel.ERROR
  )
  suspend fun getPresignedUrl(filename: String?, meetingRoomName: String): PresignedUrlResponse? {
    return try {
      val response =
        client.post("$baseUrl/meetings/genPreSignedUploadUrl") {
          contentType(ContentType.Application.Json)
          setBody(PresignedUrlRequest(meetingRoomName, filename))
        }
      response.body()
    } catch (e: Exception) {
      null
    }
  }

  suspend fun getPresignedUrl2(filename: String, roomUuid: String): PresignedUrlResponse? {
    return try {
      val response =
        client.post("$baseUrl/v1/meetings/genPreSignedUploadUrl") {
          contentType(ContentType.Application.Json)
          setBody(PresignedUrlRequest2(roomUuid, filename))
        }
      response.body()
    } catch (e: Exception) {
      null
    }
  }

  companion object {
    /**
     * Checks the Dyte base-Url passed in the MeetingInfo object and provides the base-Url for
     * PresignedUrlApiService. note: We want to keep the API version of genPreSignedUploadUrl
     * explicit so we remove the version suffix from Dyte base-Url and return the remaining URL.
     */
    internal fun getBaseUrl(dyteBaseUrl: String): String {
      return dyteBaseUrl.substringBeforeLast('/')
    }
  }

  @Serializable
  private data class PresignedUrlRequest2(
    @SerialName("roomUUID") val roomUuid: String,
    val filename: String?
  )
}
