package io.dyte.core.listeners

import io.dyte.core.models.DyteJoinedMeetingParticipant

interface DyteStageEventListener {
  /**
   * triggered when local user receives request to present, it can happen in following scenario
   * 1. when user requests to join stage and then host accepts it, user receives this callback
   * 2. hosts adds local user on stage
   */
  fun onPresentRequestReceived() {}

  fun onAddedToStage() {}

  fun onRemovedFromStage() {}

  fun onPresentRequestAdded(participant: DyteJoinedMeetingParticipant) {}

  fun onPresentRequestClosed(participant: DyteJoinedMeetingParticipant) {}

  fun onPresentRequestAccepted(participant: DyteJoinedMeetingParticipant) {}

  fun onPresentRequestRejected(participant: DyteJoinedMeetingParticipant) {}

  fun onPresentRequestWithdrawn(participant: DyteJoinedMeetingParticipant) {}

  fun onStageRequestsUpdated(accessRequests: List<DyteJoinedMeetingParticipant>) {}
}
