package io.dyte.core.controllers

import io.dyte.core.feat.DyteStage
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketPeerLeftModel
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketWebinarStagePeer
import io.dyte.core.socket.events.payloadmodel.outbound.WebSocketJoinRoomModel
import io.dyte.core.socket.socketservice.IStageSocketHandler

internal class StageController(
  private val stageSocketHandler: IStageSocketHandler,
  controllerContainer: IControllerContainer
) : BaseController(controllerContainer), IStageController {
  override lateinit var stage: DyteStage

  override val stageStatus: StageStatus
    get() = stageSocketHandler.stageStatus

  override fun init() {
    stage = DyteStage(controllerContainer, stageSocketHandler)
  }

  override fun onRequestedToPresent() {
    stageSocketHandler.onRequestedToPresent()
  }

  override fun onPeerAddedToStage(peerId: String) {
    stageSocketHandler.onPeerAddedToStage(peerId)
  }

  override fun onPeerRejectedToStage(peerId: String) {
    stageSocketHandler.onPeerRejectedToStage(peerId)
  }

  override fun onStoppedPresenting() {
    stageSocketHandler.onStoppedPresenting()
  }

  override fun onStartedPresenting() {
    stageSocketHandler.onStartedPresenting()
  }

  override fun onRequestToPresentPeerAdded(peerId: String) {
    stageSocketHandler.onRequestToPresentPeerAdded(peerId)
  }

  override fun onRequestToPresentPeerClosed(requestToPresentParticipant: WebSocketPeerLeftModel) {
    stageSocketHandler.onRequestToPresentPeerClosed(requestToPresentParticipant)
  }

  override fun onRequestToPresentPeerWithdrawn(
    requestToPresentParticipant: WebSocketWebinarStagePeer
  ) {
    stageSocketHandler.onRequestToPresentPeerWithdrawn(requestToPresentParticipant)
  }

  override fun handleRoomJoined(roomState: WebSocketJoinRoomModel) {
    stageSocketHandler.handleRoomJoined(roomState)
  }

  override fun onRemovedFromStage() {
    stageSocketHandler.handleRemovedFromStage()
  }

  override fun onStageRequestRejected() {
    stageSocketHandler.onStageRequestRejected()
  }
}

internal interface IStageController {
  val stage: DyteStage
  val stageStatus: StageStatus

  fun onStageRequestRejected()

  fun onRequestedToPresent()

  fun onRequestToPresentPeerAdded(peerId: String)

  fun onRequestToPresentPeerClosed(requestToPresentParticipant: WebSocketPeerLeftModel)

  fun onRequestToPresentPeerWithdrawn(requestToPresentParticipant: WebSocketWebinarStagePeer)

  fun onPeerAddedToStage(peerId: String)

  fun onPeerRejectedToStage(peerId: String)

  fun onStoppedPresenting()

  fun onStartedPresenting()

  fun onRemovedFromStage()

  fun handleRoomJoined(roomState: WebSocketJoinRoomModel)
}

enum class StageStatus {
  OFF_STAGE,
  REQUESTED_TO_JOIN_STAGE,
  ACCEPTED_TO_JOIN_STAGE,
  REJECTED_TO_JOIN_STAGE,
  ON_STAGE;

  companion object {
    fun fromMap(stage: String): StageStatus {
      return when (stage) {
        "offStage" -> OFF_STAGE
        "requestedToJoinStage" -> REQUESTED_TO_JOIN_STAGE
        "acceptedToJoinStage" -> ACCEPTED_TO_JOIN_STAGE
        "rejectedToJoinStage" -> REJECTED_TO_JOIN_STAGE
        "onStage" -> ON_STAGE
        else -> OFF_STAGE
      }
    }
  }

  override fun toString(): String {
    val strString =
      when (this) {
        OFF_STAGE -> "offStage"
        REQUESTED_TO_JOIN_STAGE -> "requestedToJoinStage"
        ACCEPTED_TO_JOIN_STAGE -> "acceptedToJoinStage"
        REJECTED_TO_JOIN_STAGE -> "rejectedToJoinStage"
        ON_STAGE -> "onStage"
      }

    return strString
  }
}
