package io.dyte.core.platform

import android.content.Context
import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.models.DyteJoinedMeetingParticipant
import io.dyte.core.models.DyteScreenShareMeetingParticipant

actual typealias VideoView = io.dyte.core.VideoView

class DyteAndroidVideoUtils
internal constructor(private val utilsProvider: IDytePlatformUtilsProvider) : IDyteVideoUtils {
  private val videoViews = hashMapOf<String, io.dyte.core.VideoView>()
  private val screenShareViews = hashMapOf<String, io.dyte.core.VideoView>()

  override fun getVideoView(participant: DyteJoinedMeetingParticipant): io.dyte.core.VideoView {
    return if (videoViews.containsKey(participant.id)) {
      val videoView = videoViews.getValue(participant.id)
      // videoView.renderVideo()
      videoView
    } else {
      val videoView =
        io.dyte.core.VideoView(
          utilsProvider
            .getControllerContainer()
            .platformUtilsProvider
            .getPlatformUtils()
            .getActivity() as Context
        )
      videoView.setup(utilsProvider.getControllerContainer(), participant)
      videoViews[participant.id] = videoView
      // videoView.renderVideo()
      videoView
    }
  }

  override fun getSelfPreview(): VideoView {
    val participant = utilsProvider.getControllerContainer().selfController.getSelf()
    val videoView =
      io.dyte.core.VideoView(
        utilsProvider
          .getControllerContainer()
          .platformUtilsProvider
          .getPlatformUtils()
          .getActivity() as Context
      )
    videoView.setup(utilsProvider.getControllerContainer(), participant)
    //    videoViews[participant.id] = videoView
    return videoView
  }

  override fun getScreenShareView(participant: DyteScreenShareMeetingParticipant): VideoView {
    return if (screenShareViews.containsKey(participant.id)) {
      val screenShareView = screenShareViews.getValue(participant.id)
      // screenShareView.renderScreenShare()
      screenShareView
    } else {
      val videoView =
        io.dyte.core.VideoView(
          utilsProvider
            .getControllerContainer()
            .platformUtilsProvider
            .getPlatformUtils()
            .getActivity() as Context
        )
      videoView.setup(utilsProvider.getControllerContainer(), participant)
      screenShareViews[participant.id] = videoView
      // videoView.renderScreenShare()
      videoView
    }
  }

  override fun destroyView(participant: DyteMeetingParticipant) {
    videoViews.remove(participant.id)
    screenShareViews.remove(participant.id)
  }

  override fun destroyAll() {
    videoViews.values.forEach {
      try {
        it.release()
      } catch (e: Exception) {
        e.printStackTrace()
      }
    }
    videoViews.clear()
  }
}
