package io.dyte.core.platform

import android.app.Activity
import io.dyte.core.controllers.IControllerContainer

/**
 * Dyte android platform provider
 *
 * creates and maintains platform specific code required by core sdk
 *
 * @constructor Create empty Dyte android platform provider
 */
internal class DyteAndroidPlatformProvider internal constructor(private val activity: Activity) :
  IDytePlatformUtilsProvider {
  private lateinit var _controllerContainer: IControllerContainer

  private var platformUtils: DyteAndroidPlatform? = null
  private var loggerUtils: DyteAndroidLogger? = null
  private var mediaUtils: DyteAndroidMedia? = null
  private var videoUtils: DyteAndroidVideoUtils? = null
  private var platformPermissionsUtils: DyteAndroidPlatformPermissions? = null

  override fun init(controllerContainer: IControllerContainer) {
    this._controllerContainer = controllerContainer
    loggerUtils = DyteAndroidLogger()
    mediaUtils = DyteAndroidMedia(this)
    videoUtils = DyteAndroidVideoUtils(this)
    platformUtils = DyteAndroidPlatform(activity, this)
    platformPermissionsUtils = DyteAndroidPlatformPermissions(activity)
  }

  override fun getPlatformUtils(): IDytePlatformUtils {
    return requireNotNull(platformUtils)
  }

  override fun getMediaUtils(): IDyteMediaUtils {
    return requireNotNull(mediaUtils)
  }

  override fun getControllerContainer(): IControllerContainer {
    return _controllerContainer
  }

  override fun createWebView(): IDyteWebView {
    return DyteAndroidWebView(this)
  }

  override fun getVideoUtils(): IDyteVideoUtils {
    return requireNotNull(videoUtils)
  }

  override fun getPermissionUtils(): IDytePlatformPermissionUtils {
    return requireNotNull(platformPermissionsUtils)
  }
}
