package io.dyte.core.feat

import io.dyte.core.controllers.IControllerContainer
import kotlinx.coroutines.launch

class DyteWaitlistedParticipant internal constructor(
    override val id: String,
    override val userId: String,
    override var name: String,
    override val picture: String?,
    override val isHost: Boolean,
    override val clientSpecificId: String?,
    override val flags: ParticipantFlags,
    override val presetName: String,
    controllerContainer: IControllerContainer
) : DyteMeetingParticipant(
    id, userId, name, picture,
    isHost, clientSpecificId, flags, presetName, controllerContainer) {

    companion object {
       internal fun get(participant: DyteMeetingParticipant): DyteWaitlistedParticipant {
            return  DyteWaitlistedParticipant(
                participant.id,
                participant.userId,
                participant.name,   // null in case of recorder
                participant.picture,
                participant.isHost,
                participant.clientSpecificId,
                participant.flags,
                participant.presetName,
                participant.controllerContainer)
        }
    }

    @Throws(Exception::class)
    open fun acceptWaitListedRequest() {
        serialScope.launch {
            controllerContainer.waitlistController.acceptWaitlistedRequest(this@DyteWaitlistedParticipant)
        }
    }

    @Throws(Exception::class)
    open fun rejectWaitListedRequest() {
        val self = this
        serialScope.launch {
            controllerContainer.waitlistController.rejectWaitlistedRequest(self)
        }
    }
}


