package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import io.dyte.core.socket.events.payloadmodel.inbound.WebSocketMeetingPeerUser
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * response for [OutboundMeetingEventType.GET_ROOM_STATE]
 */
@Serializable
data class WebSocketRoomStateModel(
  val roomState: RoomState? = null
) : BasePayloadModel()

@Serializable
data class RoomState(
  val displayTitle: String? = null,
  val peers: List<WebSocketMeetingPeerUser>? = null,
  val lockedMode: Boolean? = null,
  val roomUUID: String? = null,
  val config: RoomStateConfig? = null,
  val plugins: List<RoomStatePlugin>? = null,
  val roomName: String? = null
)

@Serializable
data class RoomStateConfig(
  val joinRestrictions: List<String>? = null,
  val access: RoomStateAccess? = null
)

@Serializable
data class RoomStateAccess(
  val mic: String? = null,
  val webcam: String? = null,
  val screenShare: String? = null,
  val plugins: String? = null
)

@Serializable
data class RoomStatePlugin(
  val id: String,
  val staggered: Boolean,
  val enabledBy: String,
  val stores: List<String>,
  @SerialName("ACLAccessRemovedUsers") val aclAccessRemovedUsers: List<String>,
  @SerialName("ACLAccessGrantedUsers") val aclAccessGrantedUsers: List<String>,
  @SerialName("ACLType") val aclType: String

)