package io.dyte.core.platform

import io.dyte.core.controllers.IControllerContainer

/**
 * I dependency provider
 *
 * needs to be implemented by android & iOS separately.
 *
 * @constructor Create empty I dependency provider
 */
internal interface IDytePlatformUtilsProvider {
  fun init(controllerContainer: IControllerContainer)
  fun getPlatformUtils(): IDytePlatformUtils
  fun getLogger(): IDyteLoggerUtils
  fun getMediaUtils(): IDyteMediaUtils
  fun getControllerContainer(): IControllerContainer
  fun createWebView(): IDyteWebView
  fun getVideoUtils(): IDyteVideoUtils
  fun getPermissionUtils(): IDytePlatformPermissionUtils
}
