package io.dyte.core.models

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.feat.DyteMeetingParticipant
import io.dyte.core.feat.ParticipantFlags
import io.dyte.core.platform.VideoView
import io.dyte.webrtc.MediaStreamTrack
import io.dyte.webrtc.VideoStreamTrack

class DyteScreenShareMeetingParticipant internal constructor(
    override val id: String,
    override val userId: String,
    override var name: String,
    override val picture: String?,
    override val isHost: Boolean,
    override val clientSpecificId: String?,
    override val flags: ParticipantFlags,
    override val presetName: String,
    controllerContainer: IControllerContainer
) : DyteJoinedMeetingParticipant(
    id, userId, name, picture,
    isHost, clientSpecificId, flags, presetName, controllerContainer) {

    internal var _screenShareTrack: VideoStreamTrack? = null
    val screenShareTrack: VideoStreamTrack?
        get() = _screenShareTrack

    companion object {
        fun get(participant: DyteMeetingParticipant): DyteScreenShareMeetingParticipant {
            return  DyteScreenShareMeetingParticipant(
                participant.id,
                participant.userId,
                participant.name,   // null in case of recorder
                participant.picture,
                participant.isHost,
                participant.clientSpecificId,
                participant.flags,
                participant.presetName,
                participant.controllerContainer)
        }
    }

    fun getScreenShareVideoView(): VideoView {
        return controllerContainer.participantController.getScreenShareView(this)
    }
}


