package io.dyte.core.host

import io.dyte.core.controllers.ISocketController
import io.dyte.core.observability.ILoggerController
import io.dyte.core.socket.socketservice.SocketService

internal class HostSocketHandlerFactory {
  fun create(
    useHive: Boolean,
    socketService: SocketService,
    socketController: ISocketController,
    loggerController: ILoggerController
  ): HostSocketHandler {
    return if (useHive) {
      HostSocketServiceHandler(socketService, loggerController)
    } else {
      HostSocketControllerHandler(socketController, loggerController)
    }
  }
}