package io.dyte.core.host

import io.dyte.core.controllers.ISocketController
import io.dyte.core.observability.ILoggerController
import io.dyte.core.socket.events.OutboundMeetingEventType
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.JsonPrimitive

internal class HostSocketControllerHandler(
  private val socketController: ISocketController,
  private val loggerController: ILoggerController
): HostSocketHandler {
  override suspend fun kickPeer(peerId: String): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(peerId)
      socketController.sendMessage(OutboundMeetingEventType.KICK_PEER, JsonObject(content))
      true
    } catch (e: Exception) {
      loggerController.traceError("HostSocketHandler::kick_peer_failed + ${e.message}")
      false
    }
  }

  override suspend fun kickAll(): Boolean {
    return try {
      socketController.sendMessage(OutboundMeetingEventType.KICK_ALL, null)
      true
    } catch (e: Exception) {
      loggerController.traceError("HostSocketHandler::kick_all_failed + ${e.message}")
      false
    }
  }

  override suspend fun muteAllAudio(allowUnmute: Boolean?): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["allowUnMute"] = JsonPrimitive(allowUnmute)
      socketController.sendMessage(OutboundMeetingEventType.MUTE_ALL_AUDIO, JsonObject(content))
      true
    } catch (e: Exception) {
      loggerController.traceError("HostSocketHandler::mute_all_audio_failed + ${e.message}")
      false
    }
  }

  override suspend fun muteAllVideo(): Boolean {
    return try {
      socketController.sendMessage(OutboundMeetingEventType.MUTE_ALL_VIDEO, null)
      true
    } catch (e: Exception) {
      loggerController.traceError("HostSocketHandler::mute_all_video_failed + ${e.message}")
      false
    }
  }

  override suspend fun muteAudio(peerId: String): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(peerId)
      socketController.sendMessage(OutboundMeetingEventType.MUTE_PEER_AUDIO, JsonObject(content))
      true
    } catch (e: Exception) {
      loggerController.traceError("HostSocketHandler::mute_audio_failed + ${e.message}")
      false
    }
  }

  override suspend fun muteVideo(peerId: String): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(peerId)
      socketController.sendMessage(OutboundMeetingEventType.MUTE_PEER_VIDEO, JsonObject(content))
      true
    } catch (e: Exception) {
      loggerController.traceError("HostSocketHandler::mute_video_failed + ${e.message}")
      false
    }
  }

  override suspend fun pinPeer(peerId: String): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      content["id"] = JsonPrimitive(peerId)
      socketController.sendMessage(OutboundMeetingEventType.PIN_PARTICIPANT, JsonObject(content))
      true
    } catch (e: Exception) {
      loggerController.traceError("HostSocketHandler::pin_peer_failed + ${e.message}")
      false
    }
  }

  override suspend fun unpinPeer(): Boolean {
    return try {
      val content = HashMap<String, JsonElement>()
      val nullString: String? = null
      content["id"] = JsonPrimitive(nullString)
      socketController.sendMessage(OutboundMeetingEventType.PIN_PARTICIPANT, JsonObject(content))
      true
    } catch (e: Exception) {
      loggerController.traceError("HostSocketHandler::unpin_peer_failed + ${e.message}")
      false
    }
  }
}