package io.dyte.core.controllers

import io.dyte.core.models.DyteMediaPermission.ALLOWED
import io.dyte.core.models.DyteMediaPermission.CAN_REQUEST

internal class WebinarController(controllerContainer: IControllerContainer) :
  BaseController(controllerContainer), IWebinarController {

  override fun canJoinStage(): Boolean {
    return controllerContainer.presetController.permissions.media.audioPermission == CAN_REQUEST
            || controllerContainer.presetController.permissions.media.video.permission == CAN_REQUEST
            || controllerContainer.presetController.permissions.media.video.permission == ALLOWED
            || controllerContainer.presetController.permissions.media.video.permission == ALLOWED
  }

  override fun shouldJoinStage(): Boolean {
    return controllerContainer.presetController.permissions.media.audioPermission == ALLOWED
            || controllerContainer.presetController.permissions.media.video.permission == ALLOWED
  }
}

interface IWebinarController {
  fun canJoinStage(): Boolean
  fun shouldJoinStage(): Boolean
}