package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.Serializable

/**
 * response for [OutboundMeetingEventType.CREATE_WEB_RTC_TRANSPORT]
 */
@Serializable
data class WebRtcCreateTransportModel(
  var id: String? = null,
  var iceParameters: IceParameters? = null,
  var iceCandidates: List<IceCandidate>? = null,
  var dtlsParameters: DtlsParameters? = null,
  var producing: Boolean? = null
) : BasePayloadModel()

@Serializable
data class DtlsParameters(
  var fingerprints: List<Fingerprint>? = null,
  var role: String? = null
)

@Serializable
data class Fingerprint(
  var algorithm: String? = null,
  var value: String? = null
)

@Serializable
data class IceCandidate(
  var foundation: String? = null,
  var ip: String? = null,
  var port: Int? = null,
  var priority: Int? = null,
  var protocol: String? = null,
  var type: String? = null,
  var tcpType: String? = null
)

@Serializable
data class IceParameters(
  var iceLite: Boolean? = null,
  var password: String? = null,
  var usernameFragment: String? = null
)
