package io.dyte.core.socket

sealed class SocketConnectionEvent {
  object Connecting : SocketConnectionEvent()

  object Connected : SocketConnectionEvent()

  data class Disconnected(
    val code: Int,
    val reason: String
  ) : SocketConnectionEvent()

  object ConnectionFailed : SocketConnectionEvent()

  object Reconnecting : SocketConnectionEvent()

  // Currently used only for logging purposes
  data class ReconnectionAttempt(val attemptNumber: Int) : SocketConnectionEvent()

  // Currently used only for logging purposes
  data class ReconnectionAttemptFailed(val attemptNumber: Int) : SocketConnectionEvent()

  object Reconnected : SocketConnectionEvent()

  object ReconnectionFailed : SocketConnectionEvent()
}