package io.dyte.core.controllers

import kotlinx.coroutines.launch

internal class ConnectionController(controllerContainer: IControllerContainer) :
  IConnectionController, BaseController(controllerContainer) {


  /**
   * in case of network change
   * error -> disconnect -> reconnect_attempt -> reconnect -> connect
   *
   * in case of network dropped
   *
   */
  override fun onSocketStateChanged(socketState: String) {
    controllerContainer.loggerController.traceLog("socket state changed $socketState")
    // we are not doing here anything purpose fully, we explicitely manage network state with media soup transports
  }

  override fun onSendTransportStateChanged(state: String) {
    controllerContainer.loggerController.traceLog("send transport state updated $state")
    handleTransportStateUpdated(state)
  }

  override fun onReceiveTransportStateChanged(state: String) {
    controllerContainer.loggerController.traceLog("receive transport state updated $state")
    handleTransportStateUpdated(state)
  }

  /**
   * whenever there is network change, transports from media soup goes to disconnected and then later in failed.
   * In either case we trigger meeting room disconnected and leave the call.
   */
  private fun handleTransportStateUpdated(newState: String) {
    // if (newState == "disconnected" || newState == "failed") {
	  //   closeConnections()
    //   controllerContainer.eventController.triggerEvent(DyteEventType.OnMeetingRoomDisconnected)
    // }
  }

  private fun closeConnections() {
    serialScope.launch {
      controllerContainer.loggerController.traceWarning("close connections")
      controllerContainer.socketController.disconnect()
      controllerContainer.socketService.disconnect()
      controllerContainer.sfuUtils.leaveCall()
      controllerContainer.eventController.dispose()
    }
  }
}

interface IConnectionController {
  fun onSocketStateChanged(socketState: String)

  fun onSendTransportStateChanged(state: String)
  fun onReceiveTransportStateChanged(state: String)
}
