package io.dyte.core.socket.events.payloadmodel.outbound

import io.dyte.core.socket.events.OutboundMeetingEventType
import io.dyte.core.socket.events.payloadmodel.BasePayloadModel
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * response for [OutboundMeetingEventType.GET_ROUTER_RTP_CAPABILITIES]
 */
@Serializable
data class RouterCapabilitiesModel(
  val codecs: List<Codec>? = null,
  val headerExtensions: List<HeaderExtension>? = null
) : BasePayloadModel()

@Serializable
data class Codec(
  var kind: String? = null,
  var mimeType: String? = null,
  var payloadType: Int? = null,
  var clockRate: Int? = null,
  var channels: Int? = null,
  var rtcpFeedback: List<CodecRtcpFeedback>? = null,
  var parameters: CodecParameters? = null,
  var preferredPayloadType: Int? = null
)

@Serializable
data class HeaderExtension(
  var kind: String? = null,
  var uri: String? = null,
  var preferredId: Int? = null,
  var id: Int? = null,
  var preferredEncrypt: Boolean? = null,
  var encrypt: Boolean? = null,
  var direction: String? = null
)

@Serializable
data class CodecParameters(
  @SerialName("x-google-start-bitrate")
  var xGoogleStartBitrate: Int? = null,
  var apt: Int? = null,

  @SerialName("profile-id")
  var profileId: Int? = null,

  @SerialName("packetization-mode")
  var packetizationMode: Int? = null,

  @SerialName("level-asymmetry-allowed")
  var levelAsymmetryAllowed: Int? = null,

  @SerialName("profile-level-id")
  var profileLevelId: String? = null
)

@Serializable
data class CodecRtcpFeedback(
  var type: String? = null,
  var parameter: String? = null
)