package io.dyte.core.plugins

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.events.JoinRoomEventReceiver
import io.dyte.core.plugins.socketservice.DefaultPluginsSocketHandler
import io.dyte.core.plugins.socketservice.SocketServicePluginsController
import io.dyte.core.socket.socketservice.SocketService
import kotlinx.serialization.json.Json

/**
 * Factory class to create [PluginsController] based on the *plugin_socket_server* feature flag.
 */
internal class PluginsControllerFactory {
  fun create(
    pluginSocketServer: String,
    v1PluginsConfig: String,
    socketService: SocketService,
    joinRoomEventReceiver: JoinRoomEventReceiver,
    controllerContainer: IControllerContainer
  ): PluginsController {
    val v1Plugins = v1PluginsConfig.split(',').toSet()
    val json = Json {
      encodeDefaults = true
      isLenient = true
    }
    return when (pluginSocketServer) {
      "socket-service" -> {
        val pluginsSocketHandler = DefaultPluginsSocketHandler(socketService, json)
        SocketServicePluginsController(
          meetingTitle = controllerContainer.metaController.getMeetingTitle(),
          roomName = controllerContainer.metaController.getRoomName(),
          organizationId = controllerContainer.metaController.getOrgId(),
          v1Plugins = v1Plugins,
          apiClient = controllerContainer.apiClient,
          pluginsSocketHandler = pluginsSocketHandler,
          joinRoomEventReceiver = joinRoomEventReceiver,
          controllerContainer = controllerContainer
        )
      }

      else -> {
        RoomNodePluginsController(
          v1Plugins = v1Plugins,
          apiClient = controllerContainer.apiClient,
          json = json,
          roomNodeSocket = controllerContainer.socketController,
          socketIoMessageResponseParser = controllerContainer.socketMessageResponseParser,
          joinRoomEventReceiver = joinRoomEventReceiver,
          controllerContainer = controllerContainer
        )
      }
    }
  }
}