package io.dyte.core.network.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonNames

@Serializable
data class UserDataWrapper(
  val success: Boolean,
  val data: ParticipantDataWrapper
)

@Serializable
data class UserDataWrapperV1(
  val user: ParticipantData
)

@Serializable
data class ParticipantDataWrapper(
  val participant: ParticipantData,
  val preset: ParticipantPreset
)

@Serializable
data class ParticipantData(
  val id: String,
  val name: String,
  @JsonNames("custom_participant_id", "clientSpecificId") val clientSpecificId: String,
  @JsonNames("organization_id", "organizationId") val organizationId: String,
  val picture: String? = null
)

@Serializable
data class ParticipantPreset(
  val id: String,
  @SerialName("created_at") val createdAt: String,
  @SerialName("updated_at") val updateAt: String,
  val name: String,
  val permissions: ParticipantPresetPermission,
  val ui: UserPresetUI,
  val config: ParticipantPresetConfig
)

@Serializable
data class ParticipantPresetPermission(
  @SerialName("can_accept_production_requests") val acceptProductionRequests: Boolean,
  @SerialName("accept_waiting_requests") val acceptWaitingRequests: Boolean,
  @SerialName("disable_participant_audio") val disableParticipantAudio: Boolean,
  @SerialName("disable_participant_screensharing") val disableParticipantScreenSharing: Boolean,
  @SerialName("disable_participant_video") val disableParticipantVideo: Boolean,
  @SerialName("kick_participant") val kickParticipant: Boolean,
  @SerialName("pin_participant") val pinParticipant: Boolean,
  @SerialName("can_record") val canRecord: Boolean,
  @SerialName("waiting_room_type") val waitingRoomType: String,
  val plugins: ParticipantPluginPreset,
  val polls: ParticipantPollPreset,
  val media: ParticipantMediaPreset,
  val chat: ParticipantChatPreset,
  @SerialName("hidden_participant") val hiddenParticipant: Boolean,
  @SerialName("show_participant_list") val showParticipantList: Boolean,
  @SerialName("can_edit_display_name") val canEditDisplayName: Boolean
)

@Serializable
data class ParticipantPluginPreset(
  @SerialName("can_close") val canClose: Boolean,
  @SerialName("can_start") val canStart: Boolean
)

@Serializable
data class ParticipantPollPreset(
  @SerialName("can_create") val canCreate: Boolean,
  @SerialName("can_vote") val canVote: Boolean,
  @SerialName("can_view") val canView: Boolean
)

@Serializable
data class ParticipantMediaPreset(
  val video: MediaPreset,
  val audio: MediaPreset,
  val screenshare: MediaPreset
)

@Serializable
data class MediaPreset(
  @SerialName("can_produce") val canProduce: String
)

@Serializable
data class ParticipantChatPreset(
  val public: PublicChatPreset,
  val private: PrivateChatPreset
)

@Serializable
data class PublicChatPreset(
  @SerialName("can_send") val canSend: Boolean,
  val text: Boolean,
  val files: Boolean
)

@Serializable
data class PrivateChatPreset(
  @SerialName("can_send") val canSend: Boolean,
  @SerialName("can_receive") val canReceive: Boolean,
  val text: Boolean,
  val files: Boolean
)

@Serializable
data class ParticipantPresetConfig(
  @SerialName("view_type") val viewType: String,
  val media: MediaConfig,
  @SerialName("max_video_streams") val streamsConfig: VideoStreamConfig,
  @SerialName("max_screenshare_count") val maxScreenShareCount: Int
)

@Serializable
data class MediaConfig(
  val video: VideoConfig,
  val screenshare: VideoConfig
)

@Serializable
data class VideoConfig(
  val quality: String,
  @SerialName("frame_rate") val frameRate: Int
)

@Serializable
data class VideoStreamConfig(
  val mobile: Int,
  val desktop: Int
)

@Serializable
data class UserPresetUI(
  @SerialName("design_tokens")
  val designTokens: UserPresetDesignToken
)

@Serializable
data class UserPresetDesignToken(
  @SerialName("border_radius") val borderRadius: BorderRadiusType,
  @SerialName("border_width") val borderWidth: BorderWidthType,
  @SerialName("spacing_base") val spacingBase: Int,
  val theme: String,
  val colors: UserPresetDesignColors
)

@Serializable
data class UserPresetDesignColors(
  val brand: Map<String, String>,
  val background: Map<String, String>,
  val danger: String,
  val text: String,
  @SerialName("text_on_brand") val textOnBrand: String,
  val success: String,
  @SerialName("video_bg") val videoBg: String,
  val warning: String,
)

@Serializable
enum class BorderRadiusType {
  @SerialName("rounded")
  ROUNDED,

  @SerialName("sharp")
  SHARP,

  @SerialName("extra-rounded")
  EXTRA_ROUNDED,

  @SerialName("circular")
  CIRCULAR;
}

@Serializable
enum class BorderWidthType {
  @SerialName("none")
  NONE,

  @SerialName("thin")
  THIN,

  @SerialName("fat")
  FAT;
}

