package io.dyte.core.listeners

import io.dyte.core.controllers.RequestToPresentParticipant

interface DyteWebinarEventsListener {
  /**
   * triggered when local user receives request to present, it can happen in following scenario
   *
   * 1. when user requests to join stage and then host accepts it, user receives this callback
   * 2. hosts adds local user on stage
   */
  fun onPresentRequestReceived() {}

  fun onAddedToStage() {}

  fun onRemovedFromStage() {}

  fun onPresetRequestAdded(participant: RequestToPresentParticipant) {}

  fun onPresentRequestClosed(participant: RequestToPresentParticipant) {}

  fun onPresetRequestAccepted(participant: RequestToPresentParticipant) {}

  fun onPresetRequestRejected(participant: RequestToPresentParticipant) {}

  fun onPresetRequestWithdrawn(participant: RequestToPresentParticipant) {}
}