package io.dyte.core.feat

import io.dyte.core.controllers.Controller

class DyteMeta internal constructor(private val controller: Controller) {
  val roomName: String
    get() = controller.metaController.getRoomName()

  val meetingTitle: String
    get() = controller.metaController.getMeetingTitle()

  val meetingStartedTimestamp: String
    get() = controller.metaController.getMeetingStatedTimestamp()

  val roomType: String
    get() = controller.metaController.getRoomType()

  fun toMap(): Map<String, Any?> {
    val map = HashMap<String, Any?>()
    map["roomName"] = roomName
    map["meetingTitle"] = meetingTitle
    map["meetingStartedTimestamp"] = meetingStartedTimestamp
    map["roomType"] = roomType
    return map
  }
}