package io.dyte.core.feat

import io.dyte.core.controllers.IControllerContainer
import io.dyte.core.platform.VideoView
import kotlinx.coroutines.launch

class DyteWaitlistedParticipant internal constructor(
    override val id: String,
    override val userId: String,
    override var name: String,
    override val picture: String?,
    override val isHost: Boolean,
    override val clientSpecificId: String?,
    override val flags: ParticipantFlags,
    controllerContainer: IControllerContainer
) : DyteMeetingParticipant(
    id, userId, name, picture,
    isHost, clientSpecificId, flags, controllerContainer) {

    @Throws(Exception::class)
    open fun acceptWaitListedRequest() {
        serialScope.launch {
            controllerContainer.waitlistController.acceptWaitlistedRequest(this@DyteWaitlistedParticipant)
        }
    }

    @Throws(Exception::class)
    open fun rejectWaitListedRequest() {
        val self = this
        serialScope.launch {
            controllerContainer.waitlistController.rejectWaitlistedRequest(self)
        }
    }
}


