package io.dyte.core.feat

import io.dyte.core.controllers.Controller
import io.dyte.core.controllers.LiveStreamState

class DyteLiveStream internal constructor(private val controller: Controller) {
  val liveStreamUrl: String?
    get() = controller.liveStreamController.livestreamData.liveStreamUrl
  val state: LiveStreamState
    get() = controller.liveStreamController.livestreamData.state
  val roomName: String
    get() = controller.metaController.getMeetingTitle()

  fun start() {
    controller.liveStreamController.start()
  }

  fun stop() {
    controller.liveStreamController.stop()
  }
}