package io.dyte.core

internal object Utils {
  fun getInitialsFromName(name: String): String {
    val trimmedName = name.trim()

    if (trimmedName.isBlank()) {
      return "NN"
    }

    if (trimmedName.length < 2) {
      return trimmedName.first().toString().uppercase()
    }

    val subNames = trimmedName.split(" ")
    return if (subNames.size >= 2) {
      "${subNames.first().first()}${subNames.last().first()}".uppercase()
    } else {
      subNames.first().substring(0, 2).uppercase()
    }
  }
}